//
//  MCSquareTabView.h
//  MCApplication
//
//  Created by Ali Lalani on 1/6/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

//#define minTabWidth 30.0f
#define capWidth 8.0f
#define separatorWidth 1.0f
#define buttonInnerSideMargin 11.0f
#define minimumWidth 30.0f
#define marginForImageOnly 9.0f

@interface MCSquareTabView : NSView {
	id target;
	SEL action;

	NSMutableArray *buttons;
	NSMutableArray *rects;

	float buttonWidth;

	int selectedIndex;
	int pressedIndex;
	
	float tabWidth;
	
	BOOL stretchButtonsToFitWidth;
	BOOL allowsPressOnActiveButton;

	BOOL enabled;

	NSTextAlignment tabAlignment;
}
- (void)commonInit;

- (void)addButtonWithTitle:(NSString *)aTitle;
- (void)addButtonWithImage:(NSImage *)anImage;

- (void)addButton:(NSDictionary *)button;
- (void)removeButton:(NSDictionary *)button;

- (void)recalculateTabWidth;
- (NSDictionary *)displayAttributes;
- (NSDictionary *)inactiveDisplayAttributes;
- (void)handleClickAtIndex:(int)index;
- (float)preferredWidth;

#pragma mark Accessors
- (id)target;
- (void)setTarget:(id)aTarget;

- (SEL)action;
- (void)setAction:(SEL)anAction;

- (NSMutableArray *)buttons;
- (void)setButtons:(NSMutableArray *)aButtons;

- (int)selectedIndex;
- (void)setSelectedIndex:(int)aSelectedIndex;

- (BOOL)stretchButtonsToFitWidth;
- (void)setStretchButtonsToFitWidth:(BOOL)flag;

- (BOOL)allowsPressOnActiveButton;
- (void)setAllowsPressOnActiveButton:(BOOL)flag;

- (BOOL)enabled;
- (void)setEnabled:(BOOL)flag;

- (NSTextAlignment)tabAlignment;
- (void)setTabAlignment:(NSTextAlignment)aTabAlignment;
@end
